/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    private JButton[] days;
    private JButton selectedDay = null;
    private int day;
    private Color oldDayBackgroundColor;
    private Color selectedColor;
    private Color colorRed;
    private Color colorBlue;
    private String[] dayNames;
    private Calendar calendar;
    private Calendar today;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;

    public JDayChooser() {
        this.days = new JButton[49];
        Calendar calendar = Calendar.getInstance(this.locale);
        this.today = (Calendar)calendar.clone();
        this.setLayout(new GridLayout(7, 7));
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 7) {
                int n3 = n2 + 7 * n;
                if (n == 0) {
                    this.days[n3] = new JButton(){

                        public void addMouseListener(MouseListener mouseListener) {
                        }

                        public boolean isFocusTraversable() {
                            return false;
                        }
                    };
                    this.days[n3].setBackground(new Color(180, 180, 200));
                } else {
                    this.days[n3] = new JButton("x");
                    this.days[n3].addActionListener(this);
                    this.days[n3].addKeyListener(this);
                    this.days[n3].addFocusListener(this);
                }
                this.days[n3].setMargin(new Insets(0, 0, 0, 0));
                this.days[n3].setFocusPainted(false);
                this.add(this.days[n3]);
                ++n2;
            }
            ++n;
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.initialized = true;
    }

    protected void init() {
        this.colorRed = new Color(164, 0, 0);
        this.colorBlue = new Color(0, 0, 164);
        JButton jButton = new JButton();
        this.oldDayBackgroundColor = jButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        this.calendar = Calendar.getInstance(this.locale);
        int n = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int n2 = n;
        int n3 = 0;
        while (n3 < 7) {
            this.days[n3].setText(this.dayNames[n2]);
            if (n2 == 1) {
                this.days[n3].setForeground(this.colorRed);
            } else {
                this.days[n3].setForeground(this.colorBlue);
            }
            n2 = n2 < 7 ? ++n2 : (n2 -= 6);
            ++n3;
        }
        this.drawDays();
    }

    protected void drawDays() {
        Calendar calendar = (Calendar)this.calendar.clone();
        int n = calendar.getFirstDayOfWeek();
        calendar.set(5, 1);
        int n2 = calendar.get(7) - n;
        if (n2 < 0) {
            n2 += 7;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.days[n3 + 7].setVisible(false);
            this.days[n3 + 7].setText("");
            ++n3;
        }
        calendar.add(2, 1);
        Date date = calendar.getTime();
        calendar.add(2, -1);
        Date date2 = calendar.getTime();
        int n4 = 0;
        Color color = this.getForeground();
        while (date2.before(date)) {
            this.days[n3 + n4 + 7].setText(Integer.toString(n4 + 1));
            this.days[n3 + n4 + 7].setVisible(true);
            if (calendar.get(6) == this.today.get(6) && calendar.get(1) == this.today.get(1)) {
                this.days[n3 + n4 + 7].setForeground(this.colorRed);
            } else {
                this.days[n3 + n4 + 7].setForeground(color);
            }
            if (n4 + 1 == this.day) {
                this.days[n3 + n4 + 7].setBackground(this.selectedColor);
                this.selectedDay = this.days[n3 + n4 + 7];
            } else {
                this.days[n3 + n4 + 7].setBackground(this.oldDayBackgroundColor);
            }
            ++n4;
            calendar.add(5, 1);
            date2 = calendar.getTime();
        }
        int n5 = n4 + n3 + 7;
        while (n5 < 49) {
            this.days[n5].setVisible(false);
            this.days[n5].setText("");
            ++n5;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.init();
        }
    }

    public void setDay(int n) {
        if (n < 1) {
            n = 1;
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        int n2 = calendar.get(5);
        if (n > n2) {
            n = n2;
        }
        int n3 = this.day;
        this.day = n;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        int n4 = 7;
        while (n4 < 49) {
            if (this.days[n4].getText().equals(Integer.toString(this.day))) {
                this.selectedDay = this.days[n4];
                this.selectedDay.setBackground(this.selectedColor);
                break;
            }
            ++n4;
        }
        this.firePropertyChange("day", n3, this.day);
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int n) {
        this.calendar.set(2, n);
        this.setDay(this.day);
        this.drawDays();
    }

    public void setYear(int n) {
        this.calendar.set(1, n);
        this.drawDays();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.drawDays();
    }

    public void setFont(Font font) {
        if (this.days != null) {
            int n = 0;
            while (n < 49) {
                this.days[n].setFont(font);
                ++n;
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.days != null) {
            int n = 7;
            while (n < 49) {
                this.days[n].setForeground(color);
                ++n;
            }
            this.drawDays();
        }
    }

    public String getName() {
        return "JDayChooser";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        int n = new Integer(string);
        this.setDay(n);
    }

    public void focusGained(FocusEvent focusEvent) {
        JButton jButton = (JButton)focusEvent.getSource();
        String string = jButton.getText();
        if (string != null && !string.equals("")) {
            this.actionPerformed(new ActionEvent(focusEvent.getSource(), 0, null));
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getKeyCode() == 38 ? -7 : (keyEvent.getKeyCode() == 40 ? 7 : (keyEvent.getKeyCode() == 37 ? -1 : (n = keyEvent.getKeyCode() == 39 ? 1 : 0)));
        if (n != 0) {
            int n3 = this.getComponentCount() - 1;
            while (n3 >= 0) {
                if (this.getComponent(n3) == this.selectedDay) {
                    if ((n3 += n) <= 7 || n3 >= this.days.length || !this.days[n3].isVisible()) break;
                    this.days[n3].requestFocus();
                    break;
                }
                --n3;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JDayChooser");
        jFrame.getContentPane().add(new JDayChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

